// priority: 30
// ---------------------------------------------------------------------------
// 使用方法教程：自定义宝箱锁定配置
// ---------------------------------------------------------------------------
// 核心配置对象：受管理的战利品箱子
//
// 1. 结构:
//   let 受管理的战利品箱子配置 = {
//       "战利品表ID_1": { 配置项1 },
//       "战利品表ID_2": { 配置项2 },
//       // ...更多战利品表
//   };
//
// 2. 战利品表ID (键):
//    - 字符串类型，代表一个Minecraft战利品表的资源路径。
//    - 例如："minecraft:chests/simple_dungeon", "mod_id:chests/custom_loot"
//    - 你可以通过游戏内指令 /data get block <x> <y> <z> LootTable 查看箱子的战利品表ID。
//
// 3. 配置项 (值):
//    - 一个JavaScript对象，可以包含以下可选属性：
//
//    - `提示信息`: String (可选)
//        - 当此箱子因为配置的生物列表或通用怪物而被锁定时，向玩家显示的自定义消息。
//        - 如果不提供此属性:
//            - 若因 `生物列表` 锁定，默认提示为："你需要清除守护宝箱的特定生物！"
//            - 若因通用怪物锁定，默认提示为："附近有危险！清除所有敌对生物才能打开宝箱！"
//        - 示例: `提示信息: "古老的诅咒守护着这个宝箱！"`
//
//    - `生物列表`: Array<String> (可选)
//        - 一个字符串数组，其中每个字符串是一个生物的实体ID (例如 "minecraft:zombie")。
//        - 含义：如果此数组中【任何一种】生物类型的实体在宝箱附近存活，宝箱将被锁定。
//        - 列表中的生物ID应该是唯一的，重复填写同一个ID没有额外效果。
//        - 示例: `生物列表: ["minecraft:skeleton", "minecraft:creeper"]`
//                (表示：如果附近有骷髅，【或者】有爬行者，则锁定)
//
// 4. 配置行为总结:
//    - 如果一个战利品表ID存在于 `受管理的战利品箱子配置` 中：
//        - **带有 `生物列表`**: 脚本会优先检查此 `生物列表` 中的生物。如果任何列出的生物存活，箱子锁定。
//        - **没有 `生物列表` (或列表为空)**: 脚本会检查附近是否有任何通用的敌对生物 (isMonster() == true)。
//                                      如果存在，箱子锁定。
//    - 如果一个战利品表ID【不】存在于 `受管理的战利品箱子配置` 中:
//        - 此脚本的怪物锁定逻辑将【不会】应用于该箱子。它将正常打开（除非被您的指令系统全局强制锁定）。
//
// 5. NBT键名 (用于指令交互，本脚本读取这些键):
//    - `指令控制_宝箱锁定_全局启用键` (例如: "chestLockingEnabled_global")
//    - `指令控制_宝箱锁定_全局锁定键` (例如: "chestLockingLocked")
//    - `指令控制_宝箱锁定_个人启用键` (例如: "chestLockingEnabled_personal")
//    这些键的值由您的另一个指令脚本设置。
//
// 6. 方块内部NBT键名 (本脚本写入这些键到方块实体):
//    - `逻辑锁状态NBT键_方块` (例如: "MDF_lock")
//    - `原始战利品表NBT键_方块` (例如: "MDF_loots_table")
//
// ---------------------------------------------------------------------------
let 受管理的战利品箱子配置 = {
    "minecraft:chests/abandoned_mineshaft": { // 废弃矿井宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/ancient_city": { // 远古城市宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/ancient_city_ice_box": { // 远古城市冰柜
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/bastion_bridge": { // 堡垒桥梁宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/bastion_hoglin_stable": { // 堡垒疣猪兽棚宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/bastion_other": { // 堡垒其他宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/bastion_treasure": { // 堡垒宝藏宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/buried_treasure": { // 埋藏的宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/desert_pyramid": { // 沙漠神殿宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/end_city_treasure": { // 末地城宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/igloo_chest": { // 雪屋宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/jungle_temple": { // 丛林神庙宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/jungle_temple_dispenser": { // 丛林神庙发射器
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/nether_bridge": { // 下界要塞宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/pillager_outpost": { // 掠夺者前哨站宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/ruined_portal": { // 废弃传送门宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/shipwreck_map": { // 沉船地图箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/shipwreck_supply": { // 沉船补给箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/shipwreck_treasure": { // 船宝藏箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/simple_dungeon": { // 地牢宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/spawn_bonus_chest": { // 奖励箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/stronghold_corridor": { // 要塞走廊宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/stronghold_crossing": { // 要塞十字路口宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/stronghold_library": { // 要塞图书馆宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/trail_ruins_common": { // 古迹废墟普通宝箱 (1.20+)
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/trail_ruins_rare": { // 古迹废墟稀有宝箱 (1.20+)
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/underwater_ruin_big": { // 大型水下遗迹宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/underwater_ruin_small": { // 小型水下遗迹宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_armorer": { // 村庄盔甲匠宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_butcher": { // 村庄屠夫宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_cartographer": { // 村庄制图师宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_desert_house": { // 村庄沙漠房屋宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_fisher": { // 村庄渔夫宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_fletcher": { // 村庄制箭师宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_librarian": { // 村庄图书管理员宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_mason": { // 村庄石匠宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_plains_house": { // 村庄平原房屋宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_savanna_house": { // 村庄热带草原房屋宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_shepherd": { // 村庄牧羊人宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_snowy_house": { // 村庄雪原房屋宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_taiga_house": { // 村庄针叶林房屋宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_tannery": { // 村庄制革匠宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_temple": { // 村庄神殿宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_toolsmith": { // 村庄工具匠宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/village/village_weaponsmith": { // 村庄武器匠宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "minecraft:chests/woodland_mansion": { // 林地府邸宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "aquamirae:chests/frozen_chest": { // 冰冻宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "aquamirae:chests/maze_camp_chest": { // 迷宫营地宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "aquamirae:chests/maze_common_chest": { // 迷宫普通宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "aquamirae:chests/ship_1": { // 船只1宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "aquamirae:chests/ship_2": { // 船只2宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "artifacts:chests/campsite_barrel": { // 营地木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "artifacts:chests/campsite_barrel/cobblestone": { // 营地木桶/圆石
        提示信息: "",
        生物列表: [

        ]
    },
    "artifacts:chests/campsite_barrel/cobwebs": { // 营地木桶/蜘蛛网
        提示信息: "",
        生物列表: [

        ]
    },
    "artifacts:chests/campsite_barrel/crops": { // 营地木桶/作物
        提示信息: "",
        生物列表: [

        ]
    },
    "artifacts:chests/campsite_barrel/food": { // 营地木桶/食物
        提示信息: "",
        生物列表: [

        ]
    },
    "artifacts:chests/campsite_barrel/gems": { // 营地木桶/宝石
        提示信息: "",
        生物列表: [

        ]
    },
    "artifacts:chests/campsite_barrel/ingots": { // 营地木桶/金属锭
        提示信息: "",
        生物列表: [

        ]
    },
    "artifacts:chests/campsite_barrel/minecarts": { // 营地木桶/矿车
        提示信息: "",
        生物列表: [

        ]
    },
    "artifacts:chests/campsite_barrel/ores": { // 营地木桶/矿石
        提示信息: "",
        生物列表: [

        ]
    },
    "artifacts:chests/campsite_barrel/rails": { // 营地木桶/铁轨
        提示信息: "",
        生物列表: [

        ]
    },
    "artifacts:chests/campsite_barrel/tnt": { // 营地木桶/TNT
        提示信息: "",
        生物列表: [

        ]
    },
    "artifacts:chests/campsite_chest": { // 营地宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "awesomedungeonnether:chests/awesome_dungeon": { // 宏伟下界地牢宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "betterfortresses:chests/beacon": { // 改良要塞/信标
        提示信息: "",
        生物列表: [

        ]
    },
    "betterfortresses:chests/extra": { // 改良要塞/额外
        提示信息: "",
        生物列表: [

        ]
    },
    "betterfortresses:chests/hall": { // 改良要塞/大厅
        提示信息: "",
        生物列表: [

        ]
    },
    "betterfortresses:chests/keep": { // 改良要塞/主楼
        提示信息: "",
        生物列表: [

        ]
    },
    "betterfortresses:chests/obsidian": { // 改良要塞/黑曜石
        提示信息: "",
        生物列表: [

        ]
    },
    "betterfortresses:chests/puzzle": { // 改良要塞/谜题
        提示信息: "",
        生物列表: [

        ]
    },
    "betterfortresses:chests/quarters": { // 改良要塞/营房
        提示信息: "",
        生物列表: [

        ]
    },
    "betterfortresses:chests/storage": { // 改良要塞/储藏室
        提示信息: "",
        生物列表: [

        ]
    },
    "betterfortresses:chests/worship": { // 改良要塞/祭祀区
        提示信息: "",
        生物列表: [

        ]
    },
    "betteroceanmonuments:chests/upper_side_chamber": { // 改良海底神殿/上层侧室
        提示信息: "",
        生物列表: [

        ]
    },
    "betterwitchhuts:chests/hut_0": { // 改良女巫小屋/小屋0
        提示信息: "",
        生物列表: [

        ]
    },
    "bosses_of_mass_destruction:chests/gauntlet": { // 挑战赛宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "bosses_of_mass_destruction:chests/lich_tower": { // 巫妖塔宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "bosses_of_mass_destruction:chests/obsidilith": { // 黑曜石巨怪宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "cataclysm:chests/frosted_prison_treasure": { // 霜冻监狱宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "deeperdarker:chests/ancient_temple_apex": { // 远古神殿/顶端
        提示信息: "",
        生物列表: [

        ]
    },
    "deeperdarker:chests/ancient_temple_basement": { // 远古神殿/地下室
        提示信息: "",
        生物列表: [

        ]
    },
    "deeperdarker:chests/ancient_temple_fountain": { // 远古神殿/喷泉
        提示信息: "",
        生物列表: [

        ]
    },
    "deeperdarker:chests/ancient_temple_storage": { // 远古神殿/储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "deeperdarker:chests/crystallized_amber": { // 结晶琥珀宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/abandoned_temple/abandoned_temple_entrance": { // 废弃神庙/入口
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/abandoned_temple/abandoned_temple_map": { // 废弃神庙/地图
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/abandoned_temple/abandoned_temple_top": { // 废弃神庙/顶部
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/aviary/aviary_barrels": { // 鸟舍/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/aviary/aviary_normal": { // 鸟舍/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/aviary/aviary_treasure": { // 鸟舍/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/bandit_towers/bandit_towers_barrels": { // 强盗塔楼/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/bandit_towers/bandit_towers_gardens": { // 强盗塔楼/花园
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/bandit_towers/bandit_towers_normal": { // 强盗塔楼/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/bandit_towers/bandit_towers_rooms": { // 强盗塔楼/房间
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/bandit_towers/bandit_towers_supply": { // 强盗塔楼/补给
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/bandit_towers/bandit_towers_treasure": { // 强盗塔楼/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/bandit_village/bandit_village_barrels": { // 强盗村庄/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/bandit_village/bandit_village_normal": { // 强盗村庄/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/bandit_village/bandit_village_supply": { // 强盗村庄/补给
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/bandit_village/bandit_village_tents": { // 强盗村庄/帐篷
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/bathhouse/bathhouse_barrels": { // 澡堂/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/bathhouse/bathhouse_normal": { // 澡堂/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/ceryneian_hind/ceryneian_hind_treasure": { // 刻律涅牝鹿/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/fishing_hut/fishing_hut_barrels": { // 渔夫小屋/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/foundry/foundry_chains": { // 铸造厂/锁链
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/foundry/foundry_lava_pit": { // 铸造厂/熔岩坑
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/foundry/foundry_normal": { // 铸造厂/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/foundry/foundry_passage_exterior": { // 铸造厂/外部通道
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/foundry/foundry_passage_normal": { // 铸造厂/普通通道
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/foundry/foundry_treasure": { // 铸造厂/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/giant_mushroom/red_giant_mushroom": { // 巨型蘑菇/红色
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/giant_mushroom/twin_giant_mushroom": { // 巨型蘑菇/双子
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/greenwood_pub/greenwood_pub_barrels_hallways": { // 绿林酒馆/走廊木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/greenwood_pub/greenwood_pub_barrels_normal": { // 绿林酒馆/普通木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/greenwood_pub/greenwood_pub_normal": { // 绿林酒馆/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/heavenly_challenger/heavenly_challenger_normal": { // 天堂挑战者/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/heavenly_challenger/heavenly_challenger_supply": { // 天堂挑战者/补给
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/heavenly_challenger/heavenly_challenger_theater": { // 天堂挑战者/剧场
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/heavenly_challenger/heavenly_challenger_treasure": { // 天堂挑战者/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/heavenly_conqueror/heavenly_conqueror_barrels": { // 天堂征服者/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/heavenly_conqueror/heavenly_conqueror_normal": { // 天堂征服者/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/heavenly_conqueror/heavenly_conqueror_treasure": { // 天堂征服者/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/heavenly_rider/heavenly_rider_barrels": { // 天堂骑士/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/heavenly_rider/heavenly_rider_normal": { // 天堂骑士/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/heavenly_rider/heavenly_rider_treasure": { // 天堂骑士/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_campsite/illager_campsite_map": { // 灾厄村民营地/地图
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_campsite/illager_campsite_supply": { // 灾厄村民营地/补给
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_campsite/illager_campsite_tent": { // 灾厄村民营地/帐篷
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_corsair/illager_corsair_barrels": { // 灾厄村民海盗船/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_corsair/illager_corsair_supply": { // 灾厄村民海盗船/补给
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_corsair/illager_corsair_treasure": { // 灾厄村民海盗船/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_fort/illager_fort_barrels": { // 灾厄村民堡垒/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_fort/illager_fort_normal": { // 灾厄村民堡垒/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_fort/illager_fort_treasure": { // 灾厄村民堡垒/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_galley/illager_galley_barrels": { // 灾厄村民桨帆船/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_galley/illager_galley_supply": { // 灾厄村民桨帆船/补给
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_galley/illager_galley_treasure": { // 灾厄村民桨帆船/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_windmill/illager_windmill_barrels": { // 灾厄村民风车/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/illager_windmill/illager_windmill_treasure": { // 灾厄村民风车/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/infested_temple/infested_temple_room_bookshelf": { // 神庙/书架房
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/infested_temple/infested_temple_room_forge": { // 神庙/锻造房
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/infested_temple/infested_temple_room_garden": { // 神庙/花园房
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/infested_temple/infested_temple_room_normal": { // 神庙/普通房
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/infested_temple/infested_temple_room_supply": { // 神庙/补给房
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/infested_temple/infested_temple_room_table": { // 神庙/桌子房
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/infested_temple/infested_temple_top_treasure": { // 神庙/顶部宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/jungle_tree_house/jungle_tree_house_barrels": { // 丛林树屋/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/jungle_tree_house/jungle_tree_house_normal": { // 丛林树屋/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/jungle_tree_house/jungle_tree_house_treasure": { // 丛林树屋/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/keep_kayra/keep_kayra_garden_normal": { // 凯拉要塞/花园普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/keep_kayra/keep_kayra_garden_treasure": { // 凯拉要塞/花园宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/keep_kayra/keep_kayra_library_normal": { // 凯拉要塞/图书馆普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/keep_kayra/keep_kayra_library_treasure": { // 凯拉要塞/图书馆宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/keep_kayra/keep_kayra_normal": { // 凯拉要塞/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/keep_kayra/keep_kayra_treasure": { // 凯拉要塞/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/lighthouse/lighthouse_top": { // 灯塔/顶部
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mechanical_nest/mechanical_nest_equipment": { // 机械巢穴/装备
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mechanical_nest/mechanical_nest_normal": { // 机械巢穴/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mechanical_nest/mechanical_nest_supply": { // 机械巢穴/补给
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mechanical_nest/mechanical_nest_treasure": { // 机械巢穴/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/merchant_campsite/merchant_campsite_map": { // 商人营地/地图
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/merchant_campsite/merchant_campsite_supply": { // 商人营地/补给
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/merchant_campsite/merchant_campsite_tent": { // 商人营地/帐篷
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mines_treasure_big": { // 矿井宝藏/大型
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mines_treasure_medium": { // 矿井宝藏/中型
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mines_treasure_small": { // 矿井宝藏/小型
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mining_system/mining_system_barrels": { // 采矿系统/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mining_system/mining_system_treasure": { // 采矿系统/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/monastery/monastery_barrels": { // 修道院/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/monastery/monastery_bridges": { // 修道院/桥梁
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/monastery/monastery_map": { // 修道院/地图
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mushroom_house/mushroom_house_barrels": { // 蘑菇房/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mushroom_house/mushroom_house_normal": { // 蘑菇房/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mushroom_house/mushroom_house_treasure": { // 蘑菇房/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mushroom_mines/mushroom_mines_barrels": { // 蘑菇矿井/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mushroom_mines/mushroom_mines_ores": { // 蘑菇矿井/矿石
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mushroom_mines/mushroom_mines_tools": { // 蘑菇矿井/工具
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mushroom_mines/mushroom_mines_treasure": { // 蘑菇矿井/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mushroom_village/mushroom_village_barrels": { // 蘑菇村庄/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/mushroom_village/mushroom_village_treasure": { // 蘑菇村庄/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/plague_asylum/plague_asylum_barrels": { // 瘟疫避难所/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/plague_asylum/plague_asylum_cells": { // 瘟疫避难所/牢房
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/plague_asylum/plague_asylum_normal": { // 瘟疫避难所/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/plague_asylum/plague_asylum_potions": { // 瘟疫避难所/药水
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/plague_asylum/plague_asylum_storage": { // 瘟疫避难所/储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/plague_asylum/plague_asylum_treasure": { // 瘟疫避难所/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/scorched_mines/scorched_mines_barrels": { // 焦土矿井/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/scorched_mines/scorched_mines_housing": { // 焦土矿井/住房
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/scorched_mines/scorched_mines_hub": { // 焦土矿井/中心
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/scorched_mines/scorched_mines_normal": { // 焦土矿井/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/scorched_mines/scorched_mines_treasure": { // 焦土矿井/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/shiraz_palace/shiraz_palace_elite": { // 设拉子宫殿/精英
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/shiraz_palace/shiraz_palace_gardens": { // 设拉子宫殿/花园
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/shiraz_palace/shiraz_palace_library": { // 设拉子宫殿/图书馆
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/shiraz_palace/shiraz_palace_normal": { // 设拉子宫殿/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/shiraz_palace/shiraz_palace_rooms": { // 设拉子宫殿/房间
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/shiraz_palace/shiraz_palace_supply": { // 设拉子宫殿/补给
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/shiraz_palace/shiraz_palace_towers": { // 设拉子宫殿/塔楼
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/shiraz_palace/shiraz_palace_treasure": { // 设拉子宫殿/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/small_blimp/small_blimp_coal_storage": { // 小型飞艇/煤炭储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/small_blimp/small_blimp_redstone_chamber": { // 小型飞艇/红石室
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/small_blimp/small_blimp_treasure": { // 小型飞艇/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/small_prairie_house/small_prairie_house_barrels": { // 草原小屋/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/small_prairie_house/small_prairie_house_normal": { // 草原小屋/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/small_prairie_house/small_prairie_house_ruined": { // 草原小屋/废墟
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/thornborn_towers/thornborn_towers_barrels": { // 荆棘塔楼/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/thornborn_towers/thornborn_towers_rooms": { // 荆棘塔楼/房间
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/thornborn_towers/thornborn_towers_top_rooms": { // 荆棘塔楼/顶层房间
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/thornborn_towers/thornborn_towers_top_treasure": { // 荆棘塔楼/顶层宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/typhon/typhon_treasure": { // 堤丰/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/undead_pirate_ship/undead_pirate_ship_barrels": { // 亡灵海盗船/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/undead_pirate_ship/undead_pirate_ship_enchants": { // 亡灵海盗船/附魔
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/undead_pirate_ship/undead_pirate_ship_supply": { // 亡灵海盗船/补给
        提示信息: "",
        生物列表: [

        ]
    },
    "dungeons_arise:chests/undead_pirate_ship/undead_pirate_ship_treasure": { // 亡灵海盗船/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_abandoned_mineshaft": { // 废弃矿井
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_bastion_hoglin_stable": { // 堡垒猪灵棚
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_bastion_treasure": { // 堡垒宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_end_city_treasure": { // 末地城宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_pillager_outpost": { // 掠夺者前哨站
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_ruined_portal": { // 废弃传送门
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_shipwreck_supply": { // 沉船补给
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_simple_dungeon": { // 简易地牢
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_village_butcher": { // 村庄屠夫
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_village_desert_house": { // 村庄沙漠房屋
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_village_plains_house": { // 村庄平原房屋
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_village_savanna_house": { // 村庄热带草原房屋
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_village_snowy_house": { // 村庄雪原房屋
        提示信息: "",
        生物列表: [

        ]
    },
    "farmersdelight:chests/fd_village_taiga_house": { // 村庄针叶林房屋
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/blacksmith_loot": { // 铁匠铺战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/blacksmith_treasure": { // 铁匠铺宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/crypt_book": { // 地穴书本
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/crypt_loot": { // 地穴战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/crypt_tomb": { // 地穴坟墓
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/crypt_urn": { // 地穴骨灰瓮
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/dark_manor_apothecary": { // 黑暗庄园/药剂室
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/dark_manor_attic": { // 黑暗庄园/阁楼
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/dark_manor_clutter": { // 黑暗庄园/杂物
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/dark_manor_loom": { // 黑暗庄园/织布机
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/dark_manor_treasure": { // 黑暗庄园/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/graveyard_loot": { // 墓地战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/graveyard_treasure": { // 墓地宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/lair_loot": { // 巢穴战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/lair_treasure": { // 巢穴宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/shack_attic": { // 棚屋/阁楼
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/shack_basement": { // 棚屋/地下室
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/shack_book": { // 棚屋/书本
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/shack_potion": { // 棚屋/药水
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/shack_treasure": { // 棚屋/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/shrine_loot": { // 神龛战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "goety:chests/shrine_treasure": { // 神龛宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/arrow_loot": { // 箭矢战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/bone_loot": { // 骨头战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/brewing_loot": { // 酿造战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/candle_loot": { // 蜡烛战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/creeper_loot": { // 苦力怕战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/crypt_loot": { // 地穴战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/crypt_urn_loot": { // 地穴骨灰瓮战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/desert_graveyard_loot": { // 沙漠墓地战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/flesh_loot": { // 腐肉战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/flower_loot": { // 花朵战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/great_crypt_loot": { // 大地穴战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/large_graveyard_loot": { // 大型墓地战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/large_loot": { // 大型战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/medium_graveyard_loot": { // 中型墓地战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/medium_loot": { // 中型战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/misc_loot": { // 杂项战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/ore_loot": { // 矿石战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/small_graveyard_loot": { // 小型墓地战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/small_loot": { // 小型战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/swamp_graveyard_loot": { // 沼泽墓地战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/totem_loot": { // 图腾战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "graveyard:chests/vase_loot": { // 花瓶战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "illagerinvasion:chests/illager_fort_ground": { // 灾厄堡垒/地面
        提示信息: "",
        生物列表: [

        ]
    },
    "illagerinvasion:chests/illager_fort_tower": { // 灾厄堡垒/塔楼
        提示信息: "",
        生物列表: [

        ]
    },
    "illagerinvasion:chests/illusioner_tower_entrance": { // 幻术师塔/入口
        提示信息: "",
        生物列表: [

        ]
    },
    "illagerinvasion:chests/illusioner_tower_stairs": { // 幻术师塔/楼梯
        提示信息: "",
        生物列表: [

        ]
    },
    "illagerinvasion:chests/labyrinth": { // 迷宫
        提示信息: "",
        生物列表: [

        ]
    },
    "illagerinvasion:chests/labyrinth_map": { // 迷宫地图
        提示信息: "",
        生物列表: [

        ]
    },
    "illagerinvasion:chests/sorcerer_hut": { // 巫师小屋
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/additional_ancient_city_loot": { // 额外/远古城市战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/additional_generic_loot": { // 额外/通用战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/additional_good_loot": { // 额外/优质战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/additional_nether_loot": { // 额外/下界战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/additional_treasure_loot": { // 额外/宝藏战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/battleground/burial_loot": { // 战场/墓葬战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/battleground/piglin_camp": { // 战场/猪灵营地
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/bookshelf_loot": { // 书架战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/catacombs/armory_loot": { // 地下墓穴/军械库
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/catacombs/coffin_loot": { // 地下墓穴/棺材
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/catacombs/crypt_loot": { // 地下墓穴/地穴
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/catacombs/hidden_trough_treasure": { // 地下墓穴/隐藏水槽宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/catacombs/wall_loot": { // 地下墓穴/墙壁
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/citadel/wall_loot": { // 城堡/墙壁
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/component_storage": { // 组件储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/evoker_fort": { // 唤魔者堡垒
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/evoker_fort/guard_tower": { // 唤魔者堡垒/守卫塔
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/filler_storage_loot": { // 填充储藏战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/generic_magic_treasure": { // 通用魔法宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/impaled_icebreaker/captain_quarters": { // 被刺穿的破冰船/船长室
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/impaled_icebreaker/food_barrel": { // 被刺穿的破冰船/食物桶
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/magic_bookshelf_loot": { // 魔法书架战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/mangrove_hut": { // 红树林小屋
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/mangrove_hut/hidden_potion_storage": { // 红树林小屋/隐藏药水储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/mangrove_hut/potion_ingredient_storage": { // 红树林小屋/药水材料储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/mountain_tower/ice_barrel": { // 高山塔楼/冰桶
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/mountain_tower/mountain_tower": { // 高山塔楼/主塔
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/priest_house": { // 牧师小屋
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/pyromancer_tower/burnt_chest": { // 纵火者之塔/烧焦的箱子
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/pyromancer_tower/fire_ale_cask": { // 纵火者之塔/火焰麦酒桶
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/pyromancer_tower/fire_ale_trove": { // 纵火者之塔/火焰麦酒秘藏
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/pyromancer_tower/old_cask": { // 纵火者之塔/旧木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/pyromancer_tower/pyromancer_basic_storage": { // 纵火者之塔/纵火者基础储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/pyromancer_tower/pyromancer_supplies": { // 纵火者之塔/纵火者补给
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/sewer_loot": { // 下水道战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "irons_spellbooks:chests/wheat": { // 小麦
        提示信息: "",
        生物列表: [

        ]
    },
    "majruszsenchantments:chests/ancient_city_sixth_sense": { // 远古城市/第六感
        提示信息: "",
        生物列表: [

        ]
    },
    "miners_delight:chests/md_abandoned_mineshaft": { // 废弃矿井
        提示信息: "",
        生物列表: [

        ]
    },
    "mowziesmobs:chests/monastery_chest": { // 修道院宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "mowziesmobs:chests/umvuthana_grove_chest": { // 乌姆乌萨那树林宝箱
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/aurora_cache": { // 极光秘藏
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/aurora_room": { // 极光房间
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/basement": { // 地下室
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/darktower_boss": { // 黑暗塔Boss
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/darktower_cache": { // 黑暗塔秘藏
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/darktower_key": { // 黑暗塔钥匙
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/fancy_well": { // 华丽水井
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/foundation_basement": { // 地基地下室
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/graveyard": { // 墓地
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/hedge_maze": { // 树篱迷宫
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/hill_1": { // 小山1
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/hill_2": { // 小山2
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/hill_3": { // 小山3
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/labyrinth_dead_end": { // 迷宫死路
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/labyrinth_room": { // 迷宫房间
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/labyrinth_vault": { // 迷宫宝库
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/labyrinth_vault_jackpot": { // 迷宫宝库大奖
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/quest_grove_dropper": { // 任务树林掉落物
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/stronghold_boss": { // 要塞Boss
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/stronghold_cache": { // 要塞秘藏
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/stronghold_room": { // 要塞房间
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/tower_library": { // 塔楼图书馆
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/tower_room": { // 塔楼房间
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/tree_cache": { // 树木秘藏
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/troll_garden": { // 巨魔花园
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/troll_vault": { // 巨魔宝库
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/troll_vault_with_lamp": { // 巨魔宝库带灯
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/useless": { // 无用
        提示信息: "",
        生物列表: [

        ]
    },
    "twilightforest:chests/well": { // 水井
        提示信息: "",
        生物列表: [

        ]
    },
    "vanillacookbook:chests/abandoned_mineshaft": { // 废弃矿井
        提示信息: "",
        生物列表: [

        ]
    },
    "vanillacookbook:chests/bastion_treasure": { // 堡垒宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "vanillacookbook:chests/bonus_chest": { // 奖励箱
        提示信息: "",
        生物列表: [

        ]
    },
    "vanillacookbook:chests/end_city": { // 末地城
        提示信息: "",
        生物列表: [

        ]
    },
    "vanillacookbook:chests/nether": { // 下界
        提示信息: "",
        生物列表: [

        ]
    },
    "vanillacookbook:chests/simple_dungeon": { // 简易地牢
        提示信息: "",
        生物列表: [

        ]
    },
    "vanillacookbook:chests/village_desert": { // 村庄沙漠
        提示信息: "",
        生物列表: [

        ]
    },
    "vanillacookbook:chests/village_plains": { // 村庄平原
        提示信息: "",
        生物列表: [

        ]
    },
    "vanillacookbook:chests/village_savanna": { // 村庄热带草原
        提示信息: "",
        生物列表: [

        ]
    },
    "vanillacookbook:chests/village_snowy": { // 村庄雪原
        提示信息: "",
        生物列表: [

        ]
    },
    "vanillacookbook:chests/village_taiga": { // 村庄针叶林
        提示信息: "",
        生物列表: [

        ]
    },
    "vanillacookbook:chests/woodland_mansion": { // 林地府邸
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/abandoned_small_castle/abandoned_small_castle_loot": { // 废弃小城堡/战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/abandoned_small_castle/abandoned_small_castle_soldier": { // 废弃小城堡/士兵
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/abandoned_small_castle/abandoned_small_castle_storage": { // 废弃小城堡/储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/badlands_dwelling/badlands_dwelling_bedroom": { // 恶地住所/卧室
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/badlands_dwelling/badlands_dwelling_kitchen": { // 恶地住所/厨房
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/badlands_dwelling/badlands_dwelling_storage": { // 恶地住所/储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/bamboo_firework_site/bamboo_firework_site_gunpowder": { // 竹林烟火场/火药
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/bamboo_firework_site/bamboo_firework_site_paper": { // 竹林烟火场/纸
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/basalt_castle/basalt_castle_kitchen": { // 玄武岩城堡/厨房
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/basalt_castle/basalt_castle_loot": { // 玄武岩城堡/战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/basalt_castle/basalt_castle_soldier": { // 玄武岩城堡/士兵
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/basalt_castle/basalt_castle_storage": { // 玄武岩城堡/储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/basalt_castle/basalt_castle_wither": { // 玄武岩城堡/凋灵
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/bee_farm/bee_farm": { // 蜜蜂农场
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/beetroot_patch/beetroot_patch": { // 甜菜地
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/boats/common_river_boat": { // 船只/普通内河船
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/candlemaker_house/candlemaker_house_bees": { // 蜡烛匠房屋/蜜蜂
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/candlemaker_house/candlemaker_house_chest": { // 蜡烛匠房屋/箱子
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/candlemaker_house/candlemaker_house_shop": { // 蜡烛匠房屋/商店
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/carrot_patch/carrot_patch": { // 胡萝卜地
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/chorus_orchard/chorus_orchard_arm": { // 紫颂果园/臂
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/chorus_orchard/chorus_orchard_atrium": { // 紫颂果园/中庭
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/concrete_mill_ruins/concrete_mill_ruins_desert_mill": { // 混凝土磨坊废墟/沙漠磨坊
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/concrete_mill_ruins/concrete_mill_ruins_desert_water": { // 混凝土磨坊废墟/沙漠水
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/concrete_mill_ruins/concrete_mill_ruins_shore_back": { // 混凝土磨坊废墟/海岸后部
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/concrete_mill_ruins/concrete_mill_ruins_shore_mill": { // 混凝土磨坊废墟/海岸磨坊
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/dark_witch_keep/dark_witch_keep": { // 黑暗女巫要塞
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/firewatch_tower/firewatch_tower": { // 瞭望塔
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/forgotten_remnants/forgotten_remnants_common": { // 被遗忘的残迹/普通
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/forgotten_remnants/forgotten_remnants_echoes": { // 被遗忘的残迹/回响
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/frost_reactor_plant/frost_reactor_plant_experiment": { // 霜冻反应堆工厂/实验
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/frost_reactor_plant/frost_reactor_plant_military": { // 霜冻反应堆工厂/军事
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/generic/generic_common_food": { // 通用/普通食物
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/generic/generic_common_storage": { // 通用/普通储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/generic/generic_dispenser": { // 通用/发射器
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/generic/generic_drinking_water": { // 通用/饮用水
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/generic/generic_firework_dispenser": { // 通用/烟火发射器
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/generic/generic_flame_dispenser": { // 通用/火焰发射器
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/generic/generic_grave": { // 通用/坟墓
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/hellish_orphanage/hellish_orphanage_bedside": { // 地狱孤儿院/床头
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/hellish_orphanage/hellish_orphanage_kitchen": { // 地狱孤儿院/厨房
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/hellish_orphanage/hellish_orphanage_loot": { // 地狱孤儿院/战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/hellish_orphanage/hellish_orphanage_storage": { // 地狱孤儿院/储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/hide_tannery/hide_tannery": { // 皮革制革厂
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/hide_tannery/hide_tannery_cherry": { // 皮革制革厂/樱桃木
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/ice_shanty/ice_shanty": { // 冰上小屋
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/infested_castle/infested_castle_lesser": { // 虫蚀城堡/次级
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/infested_castle/infested_castle_treasure": { // 虫蚀城堡/宝藏
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/lighthouse/lighthouse": { // 灯塔
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/llama_sanctuary/llama_sanctuary": { // 羊驼圣所
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/llama_sanctuary/llama_sanctuary_hills": { // 羊驼圣所/山丘
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/lumpy_tower/lumpy_tower": { // 块状塔楼
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/marine_observation_hub/marine_observation_hub_kitchen": { // 海洋观测中心/厨房
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/marine_observation_hub/marine_observation_hub_quarters": { // 海洋观测中心/营房
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/marine_observation_hub/marine_observation_hub_storage": { // 海洋观测中心/储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/monster_egg_banquet/monster_egg_banquet": { // 怪物蛋宴会
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/mossy_roof_house/mossy_roof_house_inside": { // 苔藓屋顶房屋/内部
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/mossy_roof_house/mossy_roof_house_porch": { // 苔藓屋顶房屋/门廊
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/mossy_roof_house/mossy_roof_house_wood": { // 苔藓屋顶房屋/木材
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/mossy_roof_shed/mossy_roof_shed": { // 苔藓屋顶棚屋
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/mushroom_house/mushroom_house": { // 蘑菇房
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/old_fort/old_fort": { // 旧堡垒
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/old_stable/old_stable": { // 旧马厩
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/old_tiny_house/old_tiny_house": { // 旧小屋
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/potato_patch/potato_patch": { // 马铃薯地
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/sandy_hidey_hole/sandy_hidey_hole": { // 沙地藏身处
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/sphinx_hidey_hole/sphinx_hidey_hole_icy": { // 狮身人面像藏身处/冰冷
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/spider_cellar/spider_cellar_potion": { // 蜘蛛地窖/药水
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/spider_cellar/spider_cellar_storage": { // 蜘蛛地窖/储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/spruce_cabin/spruce_cabin": { // 云杉小屋
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/spruce_cabin/spruce_cabin_secret": { // 云杉小屋/秘密
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/strider_stable/strider_stable": { // 炽足兽厩
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/sunken_steamboat/sunken_steamboat_loot": { // 沉没蒸汽船/战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/sunken_steamboat/sunken_steamboat_storage": { // 沉没蒸汽船/储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/tall_birch_house/tall_birch_house": { // 高大桦木房屋
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/tree_cage/tree_cage": { // 树笼
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/vigilante_fort/vigilante_fort_loot": { // 治安官堡垒/战利品
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/vigilante_fort/vigilante_fort_storage": { // 治安官堡垒/储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/wandering_trader_cart/wandering_trader_cart_mineral": { // 流浪商人货车/矿物
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/wandering_trader_cart/wandering_trader_cart_plant": { // 流浪商人货车/植物
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/wandering_trader_cart/wandering_trader_cart_value": { // 流浪商人货车/有价值
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/wandering_trader_cart_cold/wandering_trader_cart_cold_shop": { // 流浪商人货车寒冷/商店
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/wandering_trader_cart_cold/wandering_trader_cart_cold_storage": { // 流浪商人货车寒冷/储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/warped_ender_claw/warped_ender_claw": { // 诡异末影之爪
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/wheat_patch/wheat_patch": { // 小麦地
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/woody_camp/woody_camp": { // 林地营地
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/zen_chair_museum/zen_chair_museum_attic": { // 禅意椅子博物馆/阁楼
        提示信息: "",
        生物列表: [

        ]
    },
    "wabi_sabi_structures:chests/zen_chair_museum/zen_chair_museum_storage": { // 禅意椅子博物馆/储藏
        提示信息: "",
        生物列表: [

        ]
    },
    "youkaishomecoming:chests/cirno_nest/cabinet": { // 琪露诺的巢穴/柜子
        提示信息: "",
        生物列表: [

        ]
    },
    "youkaishomecoming:chests/hakurei_shrine/barrel": { // 博丽神社/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "youkaishomecoming:chests/hakurei_shrine/cabinet": { // 博丽神社/柜子
        提示信息: "",
        生物列表: [

        ]
    },
    "youkaishomecoming:chests/hakurei_shrine/chest": { // 博丽神社/箱子
        提示信息: "",
        生物列表: [

        ]
    },
    "youkaishomecoming:chests/youkai_nest/barrel": { // 妖怪巢穴/木桶
        提示信息: "",
        生物列表: [

        ]
    },
    "youkaishomecoming:chests/youkai_nest/chest": { // 妖怪巢穴/箱子}
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/abandoned_villa": { // 废弃别墅
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/balloon": { // 气球
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/bees": { // 蜜蜂
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/end_temple_chest": { // 末地神殿箱子
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/flooded_temple_chest": { // 洪水神殿箱子
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/guardian_meeting": { // 守护者会议
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/harbour_chest": { // 港口箱子
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/high_temple": { // 高等神殿
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/infested_prison": { // 虫蚀监狱
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/jungle_tower_chest": { // 丛林塔箱子
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/mayan_temple": { // 玛雅神庙
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/mineral_temple_chest": { // 矿物神殿箱子
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/modern_villa": { // 现代别墅
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/nether_pyramid_chest1": { // 下界金字塔箱子1
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/nether_pyramid_chest2": { // 下界金字塔箱子2
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/nether_shrine_chest": { // 下界神殿箱子
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/nether_shrine_chest1": { // 下界神殿箱子1
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/nether_shrine_chest2": { // 下界神殿箱子2
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/oasis_shrine": { // 绿洲神殿
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/oriental_hut_chest": { // 东方小屋箱子
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/player_house_chest": { // 玩家房屋箱子
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/small_temple": { // 小神庙
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/traderhouse": { // 商人之家
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/watchtower": { // 瞭望塔
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/water_shrine": { // 水神殿
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/witch_house": { // 女巫小屋
        提示信息: "",
        生物列表: [

        ]
    },
    "shrines:chests/world_tree_manor": { // 世界树庄园
        提示信息: "",
        生物列表: [

        ]
    }
};